' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.IO

Partial Class InsertUpdateProduct
  Inherits System.Web.UI.Page

  Private _id As Integer = -1

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Request.QueryString.Get("id") IsNot Nothing Then
      _id = Convert.ToInt32(Request.QueryString.Get("id"))
      PageTitle.InnerText = "Edytuj produkt"
    Else
      PageTitle.InnerText = "Dodaj nowy produkt"
    End If
    If Not Page.IsPostBack Then
      LoadData()
    End If
  End Sub

  Private Sub LoadData()
    Dim myProduct As Product = Product.Get(_id)
    If myProduct IsNot Nothing Then
      txtTitle.Text = myProduct.Title
      txtTagLine.Value = myProduct.TagLine
      txtDescription.Value = myProduct.Description
      If myProduct.ImageUrl IsNot String.Empty Then
        imgProduct.ImageUrl = myProduct.ImageUrl
        fsImage.Visible = True
      End If
      txtKeywords.Text = myProduct.Keywords

      ' Teraz pobierz kategorie. Zapamitalimy tylko ostatni poziom, wic musimy pobra
      ' pozostae poziomy w oparciu o ostatni
      Dim dsCategories As DataSet = Category.GetCategoryPath(myProduct.CategoryId)
      If dsCategories.Tables.Count > 0 Then
        Dim myRow As DataRow
        Select Case dsCategories.Tables(0).Rows.Count
          Case 1
            lstCategoryLevel1.DataBind()
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
          Case 2
            lstCategoryLevel1.DataBind()
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel2.DataBind()
            myRow = dsCategories.Tables(0).Rows(1)
            lstCategoryLevel2.SelectedIndex = -1
            lstCategoryLevel2.Items.FindByValue(myRow("Id").ToString()).Selected = True
          Case 3
            lstCategoryLevel1.DataBind()
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel2.DataBind()
            myRow = dsCategories.Tables(0).Rows(1)
            lstCategoryLevel2.SelectedIndex = -1
            lstCategoryLevel2.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel3.DataBind()
            myRow = dsCategories.Tables(0).Rows(2)
            lstCategoryLevel3.SelectedIndex = -1
            lstCategoryLevel3.Items.FindByValue(myRow("Id").ToString()).Selected = True
        End Select
      End If
    End If
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    ' Tu sprawd poprawno i zmie dane
    Dim title As String = String.Empty
    If txtTitle.Text.Length > 100 Then
      title = txtTitle.Text.Substring(0, 100)
    Else
      title = txtTitle.Text
    End If

    If Page.IsValid Then
      ' Najpierw zapisz obrazek
      Dim fullUploadLocation As String = String.Empty
      Dim fullUploadLocationMapped As String = String.Empty
      If fileImage.HasFile Then
        Dim imageName As String = Guid.NewGuid.ToString() & Path.GetExtension(fileImage.PostedFile.FileName)
        Dim imageFolderName As String = AppConfiguration.UploadFolder
        Dim imageFolderNameMapped As String = Server.MapPath(imageFolderName)
        If Not Directory.Exists(imageFolderNameMapped) Then
          Directory.CreateDirectory(imageFolderNameMapped)
        End If
        fullUploadLocation = Path.Combine(imageFolderName, imageName)
        fullUploadLocationMapped = Path.Combine(imageFolderNameMapped, imageName)
        fileImage.SaveAs(fullUploadLocationMapped)
      End If

      Dim myProduct As Product
      If _id > -1 Then
        myProduct = Product.Get(_id)
      Else
        myProduct = New Product()
      End If
      myProduct.Title = txtTitle.Text
      myProduct.TagLine = txtTagLine.Value
      myProduct.Description = txtDescription.Value
      ' Obsu kategori. Poziom 1 jest wymagany, numer 2 i 3 nie. Zapisujemy tylko najgbszy poziom
      If Not lstCategoryLevel3.SelectedValue = "" Then
        myProduct.CategoryId = Convert.ToInt32(lstCategoryLevel3.SelectedValue)
      ElseIf lstCategoryLevel2.SelectedValue = "" Then
        myProduct.CategoryId = Convert.ToInt32(lstCategoryLevel2.SelectedValue)
      Else
        myProduct.CategoryId = Convert.ToInt32(lstCategoryLevel1.SelectedValue)
      End If

      If fileImage.HasFile Then
        ' Jeli to moliwe usu stary obrazek
        Try
          File.Delete(Server.MapPath(myProduct.ImageUrl))
        Catch ex As Exception
          ' Ojej, nie mona usun pliku. Moe ju nie istnieje.
        End Try
        ' Teraz ustaw nowy ImageUrl
        myProduct.ImageUrl = fullUploadLocation
      End If
      myProduct.Keywords = txtKeywords.Text

      myProduct.Save()
      Response.Redirect("Products.aspx")
    End If

  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Response.Redirect("Products.aspx")
  End Sub

  Protected Sub lstCategoryLevel2_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel2.DataBound
    lstCategoryLevel3.DataBind()
  End Sub
End Class
